using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace LuePisteVari
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Texture2D tekstuuri;
        SpriteFont pisteFontti;
        Color[] taustanvari = new Color[1];

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            IsMouseVisible = true;


            graphics.PreferredBackBufferWidth = 1200;
            graphics.PreferredBackBufferHeight = 800;
#if	!DEBUG 
	         graphics.IsFullScreen	 	true; 
#endif
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            tekstuuri = Content.Load<Texture2D>(@"Kuvat/Sprite-0003");
            pisteFontti = Content.Load<SpriteFont>(@"Fontit\arial");

        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (Mouse.GetState().LeftButton == ButtonState.Pressed &&
                // If the left button is pressed
             Mouse.GetState().X > 0 && Mouse.GetState().Y > 0 &&
                // and we are inside the game window
             (Mouse.GetState().X <
             GraphicsDevice.PresentationParameters.BackBufferWidth) &&
            (Mouse.GetState().Y <
             GraphicsDevice.PresentationParameters.BackBufferHeight))
            {
                Rectangle pistenelio =
                new Rectangle(Mouse.GetState().X, Mouse.GetState().Y, 1, 1);

                try
                {
                    tekstuuri.GetData<Color>(
                        0,
                        pistenelio,
                        taustanvari,
                        0,
                        1);
                }
                catch { }


            }
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Green);

            spriteBatch.Begin();
            spriteBatch.Draw(tekstuuri, Vector2.Zero, null, Color.White, 0, Vector2.Zero, 1, SpriteEffects.None, 0);
            Color vari = new Color(158, 125, 255);
            Color vari2 = new Color(0, 65, 255);
            Color vari3 = new Color(0, 125, 255);
            Color vari4 = new Color(0, 190, 255);
            Color vari5 = new Color(0, 255, 0);
            
            spriteBatch.DrawString(pisteFontti, "Vri: " + taustanvari[0],
             new Vector2(10, 10), Color.DarkBlue, 0, Vector2.Zero,
             1, SpriteEffects.None, 1);

            if (taustanvari[0] == vari)
            {
                spriteBatch.DrawString(pisteFontti, "Vri on violetti.",
                 new Vector2(10, 50), Color.DarkBlue, 0, Vector2.Zero,
                 1, SpriteEffects.None, 1);
            }

            if (taustanvari[0] == vari2)
            {
                spriteBatch.DrawString(pisteFontti, "Vri on tumman sininen.",
                 new Vector2(10, 50), Color.DarkBlue, 0, Vector2.Zero,
                 1, SpriteEffects.None, 1);
            }

            if (taustanvari[0] == vari3)
            {
                spriteBatch.DrawString(pisteFontti, "Vri on sininen.",
                 new Vector2(10, 50), Color.DarkBlue, 0, Vector2.Zero,
                 1, SpriteEffects.None, 1);
            }

            if (taustanvari[0] == vari4)
            {
                spriteBatch.DrawString(pisteFontti, "Vri on vaalean sininen. ",
                 new Vector2(10, 50), Color.DarkBlue, 0, Vector2.Zero,
                 1, SpriteEffects.None, 1);
            }

            if (taustanvari[0] == vari5)
            {
                spriteBatch.DrawString(pisteFontti, "Vri on vihre. ",
                 new Vector2(10, 50), Color.DarkBlue, 0, Vector2.Zero,
                 1, SpriteEffects.None, 1);
            }
            spriteBatch.End();

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
