using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Viiva
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            IsMouseVisible = true;

            graphics.PreferredBackBufferWidth = 1000;
            graphics.PreferredBackBufferHeight = 800;
#if	!DEBUG 
	         graphics.IsFullScreen	 	true; 
#endif 
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // TODO: Add your update logic here
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);
            int x = 500;
            int y = 400;
            int x2 = 0;
            int y2 = 0;
            if (Mouse.GetState().LeftButton == ButtonState.Pressed)
          
            {
                x2 = Mouse.GetState().X;
                y2 = Mouse.GetState().Y;
                Color vari = Color.Yellow;
                // tai nin rgb: Color vari = new Color(255,255,0);
                ViivanPiirto(x, y, x2, y2, 1, vari);
                
            }
                  
            base.Draw(gameTime);
        }

        public void ViivanPiirto(int x, int y, int x2, int y2, int paksuus, Color vari)
        {
            spriteBatch.Begin();
            double k = (double)(y2 - y) / (double)(x2 - x);
            
            double x3 = 0;
            double y3 = 0;
            Texture2D viiva = new Texture2D(GraphicsDevice, 1, 1, false,
             SurfaceFormat.Color);
           
            Int32[] pixel = { 0xffffff };
            viiva.SetData<Int32>(pixel, 0, viiva.Width * viiva.Height);
            
            double i = x;
            if (x2 > x)
            {
                while (i < x2)
                {

                    Rectangle nelio = new Rectangle(x + (int)x3, y + (int)y3, paksuus, paksuus);
                    spriteBatch.Draw(viiva, nelio, vari);
                    i = i + 0.1;
                    x3 = x3 + 0.1;
                    y3 = k * x3;
                }
            }
            if (x2 < x)
            {
                i = x2;
                while (i < x)
                {

                    Rectangle nelio = new Rectangle(x - (int)x3, y - (int)y3, paksuus, paksuus);
                    spriteBatch.Draw(viiva, nelio, vari);
                    i = i + 0.1;
                    x3 = x3 + 0.1;
                    y3 = k * x3;
                }
            }
            spriteBatch.End();
            
        }
    }
}
